; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.
;
; 12-Feb-09 NEHolt now passing in the second, parallel list for BOM report data that indicates
;    what each element in the display list is... 1=main BOM element, 2=Subassy or Multi-cat
;    element. This list must be kept in synch with the main display list if entries in
;    the main display list are reordered.
; 19-Jun-06 NEHolt added WDTAGALT merge option
; 24-Sep-03 NEHolt globalized
; 29-Sep-02 NEHolt adjusted for calling from either VIA-WD Add-on or Stand Alone. Stand 
;    Alone requires that only one overall routine is defined, must be called "_wd_post_main". 
;    Any subroutines defined in this file MUST be defined internal to this main routine.
; 29-Sep-02 NEHolt added QTYxSUB-->QTY example (option #2)
; 04-Oct-01 NEHolt added QTYxSUBxUSER1(unit cost)=USER2(total cost) example
; 02-Jul-01 NEHolt N8 Solutions, Inc / VIA Development. Created 
;    as sample post-process util
; ---------  B O M . L S P  -----------------------------
;
; This routine is called from AutoCAD Electrical's "User post" button on the
; schem BOM report dialog display. Report data is passed to this
; routine in AutoLISP variable called "wd_rdata". This utility can
; then operate on this report data, reformat it into a new list of
; report data "rtrn" and then pass it back to the report dialog 
; through a call to (c:wd_rtrn_2wd rtrn) shown at the end of this file.
;

; -- main program execution begins here --
(defun _wd_post_main ( / rtrn dclnam dcl_id user_1 user_2 user_3 cancel xx wlay1
                         lay_map_lst data unitcost cost qty subqty newdatalst
                         wd_make_dcl wd_nth_subst x 
                         combined_data comp_data f hdl_lst hit ix lst n
                         scratch_fnam newlst slen str tag_lst wdtagalt temp val param_lst
                         combined_data combined_data_dsplstwhat)
                         ; Do not define "wd_rdata" as local variable!
  ; -- internal subroutine
  (defun wd_nth_subst ( n val lst / newlst ix slen x )
    ; Substitute the nth member of a list "lst" with new value "val"
    ; If "n" is past end of existing list then blank positions "nil" padded
    (if (not lst)
      (setq slen 0)
      (setq slen (length lst))
    )
    (cond
      ((minusp n)  ) ; rtrn orig list if pos is neg number
      ((zerop n) (setq lst (cons val (cdr lst)))) ; n=0, replace 1st item
      ((= n slen) (setq lst (append lst (list val)))) ; new last item
      ((< n slen) ; Insert item somewhere else in list
        (setq ix 0)
        (setq newlst '())
        (foreach x lst
          (if (/= ix n)
            (setq newlst (cons x newlst)) ; reuse existing
            (setq newlst (cons val newlst)) ; substitute new
          )
          (setq ix (1+ ix))
        )
        (setq lst (reverse newlst))
        (setq newlst nil)
      )
      ((> n slen) ; lengthen list, add "nil" pads as req'd
        (setq lst (reverse lst))
        (while (< slen n)
          (setq lst (cons nil lst))  ; add pads
          (setq slen (1+ slen))
        )
        (setq lst (reverse (cons val lst))) ; tack new item on end
    ) )
   lst
  )                         
  ; -- main routine --
  (setq rtrn nil)
  (setq temp nil)
  ; AutoCAD Electrical passes the BOM report displayed data as a list of lists of lists in variable
  ; called wd_rdata. The first element of this list is the list of lists of report data.
  ; The 2nd element is a parallel list of digits indicating "what" each sublist is: 
  ; 1=main BOM entry, 2=subassy or multi-catalog entry.
  (if (AND wd_rdata (car wd_rdata) (listp (car wd_rdata)))
    (progn
      (setq combined_data (car wd_rdata)) ; raw BOM data list of lists
      (setq combined_data_dsplstwhat (cadr wd_rdata)) ; parallel list of flags (1=main, 2=subassy or multi-cat)
  ) )

  ; Look for dcl file of same name, open if found.
  (setq cancel nil)
  ; see if running as pre-process or auto report. won't work for those below that require selection from dialog
  (if GBL_wd_postprocess
    (progn
      (if (listp GBL_wd_postprocess)
        (progn
          (if (> (length GBL_wd_postprocess) 1)
            (setq param_lst (cadr GBL_wd_postprocess)) ; optional for any selections within this function. none defined yet
            (setq param_lst nil)
          )
          (setq GBL_wd_postprocess (car GBL_wd_postprocess)) ; should be which one to run  
      ) )    
      (if (= (type GBL_wd_postprocess) 'INT) (setq GBL_wd_postprocess (itoa GBL_wd_postprocess)))
      (cond
        ((= GBL_wd_postprocess "1") (setq user_1 "1")) 
        ((= GBL_wd_postprocess "2") (setq user_2 "1")) 
        ((= GBL_wd_postprocess "3") (setq user_3 "1"))
        (T (setq cancel 1)) ; not a valid value
      )
  ) )      
  ; Look for dcl file of same name, open if found.
  (if (AND (not GBL_wd_postprocess) ; otherwise bypass dialog
           (setq dclnam (c:ace_find_file "bom.dcl" 16))) ; 16=display error dialog if file not found
    (progn
      (setq dcl_id (load_dialog dclnam))                
      (if (new_dialog "main_select" dcl_id)
        (progn
          (setq user_1 "0") ; Default state of toggles
          (setq user_2 "0")
          (setq user_3 "0")      
          (set_tile "user1" user_1) ; set toggles per defaults above
          (set_tile "user2" user_2)
          (set_tile "user3" user_3)
          (action_tile "user1" "(setq user_1 $value)")
          (action_tile "user2" "(setq user_2 $value)")
          (action_tile "user3" "(setq user_3 $value)")
          (action_tile "cancel" "(setq cancel 1)")
          (start_dialog)
          (unload_dialog dcl_id)
  ) ) ) )
  
  ; Each sublist within "combined_data" list of lists:
  ; nth 0=ITEM
  ; nth 1=QTY
  ; nth 2=SUBQTY
  ; nth 3=CAT
  ; nth 4=MFG
  ; nth 5=ASSYCODE
  ; nth 6=
  ; nth 7=catalog DESC
  ; nth 8=catalog QUERY2 field
  ; nth 9=catalog QUERY3 field
  ; nth 10=catalog MISC1 field
  ; nth 11=catalog MISC2 field
  ; nth 12=catalog USER1 field
  ; nth 13=catalog USER2 field
  ; nth 14=catalog USER3 field
  ; nth 15=TABNAM
  ; nth 16=
  ; nth 17=
  ; nth 18=
  ; nth 19=
  ; nth 20=
  ; nth 21=(sublist of TAG-ID's)
  ; nth 22= 
  ; nth 23=(sublist of (hdl dwgix))
  ; nth 24=(sublist of lists of (DESC1 DESC2 DESC3 INST LOC "" "" "")
   
  (if (AND combined_data (not cancel))
    (progn ; user didn't cancel out of dialog, okay to continue
      (if (= user_1 "1")
        (progn ; multiply QTY times SUBQTY times USER1 unit cost, dump product into USER2 field
          (setq newdatalst nil)
          (foreach lst combined_data
            (setq qty (nth 1 lst))
            (if (= qty "")(setq qty "1"))
            (setq subqty (nth 2 lst))
            (if (OR (= subqty "")(= subqty "0"))(setq subqty "1"))
            (if (= (substr subqty 1 1) "*")(setq subqty (substr subqty 2)))
            (setq unitcost (atof (nth 12 lst))) ; USER1 field value = UNIT COST
            (if (AND (> unitcost 0.0) (> (* (atof qty) (atof subqty)) 0.0))
              (progn
              
                (setq cost (* unitcost (* (atof qty) (atof subqty))))          
                ; Convert value to text string
                (setq str (rtos cost 2 2)) ; convert to string decimal
                ; Substitute value into the USER2 field
                (setq lst (wd_nth_subst 13 str lst)) 
            ) )
            (setq newdatalst (cons lst newdatalst))
          )
          (setq combined_data (reverse newdatalst)) ; put back in original order
      ) )
      (if (= user_2 "1")
        (progn
          (setq newdatalst nil)
          (foreach lst combined_data
            (setq x (nth 1 lst))
            (if (/= x "")(setq qty x)) ; Blank QTY probably means 2+ line of BOM entry, keep prev QTY value
            (if (OR (not qty)(= qty ""))(setq qty "1"))
            (setq subqty (nth 2 lst))
            (if (= subqty "")(setq subqty "1"))
            (if (= (substr subqty 1 1) "*")(setq subqty (substr subqty 2)))
            (setq x (* (atof qty) (atof subqty)))          
            ; Convert value to text string
            (setq str (rtos x 2 0)) ; convert to string decimal
            ; Substitute value back into the QTY field
            (setq lst (wd_nth_subst 1 str lst)) 
            ; Blank out the SUBQTY column
            (setq lst (wd_nth_subst 2 "" lst))            
            (setq newdatalst (cons lst newdatalst))
          )
          (setq combined_data (reverse newdatalst)) ; put back in original order
      ) )      
      (if (= user_3 "1")
        (progn
          (setq newdatalst nil)
          ; Query the COMP table, pull out all HDL, DWGIX, and WDTAGALT field value combos
          (if (setq scratch_fnam (c:wd_mdb_get_proj_scratch_dbnam nil)) ; "nil"=get current proj mdb file name
            (progn ; have active project's scratch database filename    
              (setq f (wd_dbase_GetNextHandle 1)) ; prepare to access active project's scratch mdb file
              (if f
                (progn
                  (if (setq x (wd_dbase_OpenDatabase f scratch_fnam 1))
                    (progn
                      (setq comp_data (wd_dbase_GetAllRecords f "COMP" "HDL,DWGIX,WDTAGALT" 
                                             "WDTAGALT is NOT NULL" ""))
                  ) )
                  (wd_dbase_ReleaseHandle f)
                  (setq f nil)
                  
                  (if comp_data
                    (progn ; some WDTAGALT data found in COMP table, continue
                      (foreach lst combined_data
                        (setq hit nil)
                        (setq hdl_lst (nth 23 lst))
                        (setq tag_lst (nth 21 lst))
                        (setq ixn 0)
                        (foreach x hdl_lst ; (format is (list h=hdl dwgix))
                          (foreach xx comp_data
                            (if (AND (= (car x) (cdr (car xx))) ; match on HDL
                                     (= (cadr x) (cdr (cadr xx)))) ; match on DWGIX
                              (progn
                                (setq wdtagalt (cdr (caddr xx))) ; pull out WDTAGALT value
                                (setq main_tag (nth ixn tag_lst)) ; existing main TAG (one with CAT num)
                                (setq tag_lst (wd_nth_subst ixn (strcat main_tag "(" wdtagalt ")") tag_lst))
                                (setq hit 1) ; remember that a change has taken place
                          ) ) )      
                          (setq ixn (1+ ixn))
                        )         
                        (if hit
                          (progn ; revised the TAGNAME list, insert back into report data
                            (setq lst (wd_nth_subst 21 tag_lst lst))
                        ) )
                        (setq newdatalst (cons lst newdatalst))
                      )
                      (setq combined_data (reverse newdatalst))
            ) ) ) ) )
          )
      ) )
    )  
  )  
  (setq rtrn (list combined_data combined_data_dsplstwhat))
  (c:wd_rtrn_2wd rtrn) ; return post-processed list back to AutoCAD Electrical's report dialog
                       ; = nil or combined_data list of lists
)

; -- the following AUTO-STARTS when this file is "loaded" from within AutoCAD Electrical (i.e.
;    user hits the "User post" button on a report display dialog)
(_wd_post_main) ; run the above program 
(princ)

